'''
In diesem Programm wird das Interface des Chatbots mit Tkinter programmiert, so dass User einfach
mit dem Sprachmodell kommunizieren können.
'''

# Importieren der noetigen Bibliotheken
from tkinter import *
import tkinter as tk
import setup_ai as chatbot # Schnittstelle zum Sprachmodell und dessen Gedaechtnis

# Definieren des Fensters
window = Tk()
window.title('Chatbot')

# Erstellen des Textfelds
text_area = Text(window, bg="white", width=120, height=80) # Feldgroeße kann angepasst werden
text_area.pack()

# Erstellen des Inputfelds
input_field = Entry(window, width=100)
input_field.pack()

# Button zum Absenden der Anfrage erstellen
send_button = Button(window, text="Chat!", command=lambda: send_message())
send_button.pack()

def send_message(event) -> None:
    '''
    send_message() ist das Hauptelement des Chatbots.
    Mit dieser Funktion werden Anfragen gesammelt, Antworten ermittelt und angegeben.
    '''

    # Eingabefeld einlesen und fuer naechste Anfrage leeren
    user_input = input_field.get()
    input_field.delete(0, END)

    # Eingabe ins Textfeld schreiben und speichern im Gedaechtnis des Chatbots
    text_area.insert(END, f"You: {user_input}\n")
    text_area.insert(END, f"\n") # Leerzeile für bessere Lesbarkeit
    chatbot.collect_input(user_input)

    # Antwort des Sprachmodells abfragen und speichern im Gedaechtnis
    response = chatbot.get_completion_from_messages(chatbot.context)
    chatbot.collect_responses(response)

    # Antwort im Textfeld des Chatbots darstellen
    text_area.insert(END, f"Chatbot: {response}\n")
    text_area.insert(END, f"\n \n") # Zwei Leerzeilen für bessere Lesbarkeit

# ENTER-Taste mit Sendetaste gleichsetzen
input_field.bind_all('<Return>', send_message)

# Endlosschleife, damit der Chatbot bei einer abgesendeten Anfrage reagieren kann
window.mainloop()
